function TimedAnimation()
t = linspace(-pi,+pi,700);
x = cos(t);
y = sin(2*t);

tic;           %start timing
method1(x,y);  %method from exercise 2, task 1 (see end of this m-file)
toc;           %stop timing, display execution time in command window

tic;           %start timing
method2(x,y);  %new method
toc;           %stop timing, display execution time in command window


%%%% local functions, functions that will only be used in this m-file can
%%%% be listed at the end in the following way:
function method1(x,y)
for p = 1:length(x)
   plot(x(p),y(p), 'o');
   xlim([-1.5,1.5]);
   ylim([-1.5,1.5]);
   drawnow;             %update to screen
end



function method2(x,y)
%initialization, create the graphics object only once:
hDot = plot(x(1),y(1), 'o');
xlim([-1.5,1.5]);
ylim([-1.5,1.5]);
%rendering, perform the change over time on the graphics object
for p = 2:length(x)
   set(hDot,'XData',x(p),'YData',y(p));
   drawnow;
end