import gradio as gr


def inference(x, ratio):
    width, height = x.size

    left = int(width * ratio)
    right = int(width * (1 - ratio))
    top = int(height * ratio)
    bot = int(height * (1 - ratio))

    return x.crop((left, top, right, bot))


def slider_changed(ratio):
    ratio = str(ratio)
    return gr.Textbox.update(value=ratio)


with gr.Blocks() as demo:
    gr.Markdown("Crop your *image* here!")
    with gr.Row():
        with gr.Column():
            image_input = gr.Image(label='Input', type='pil').style(height=300)
        with gr.Column():
            image_output = gr.Image(label='Output', type='pil').style(height=300)

    with gr.Accordion("Options", open=False):
        slider = gr.Slider(minimum=0.01,
                           maximum=0.49,
                           value=0.2,
                           label='Crop ratio',
                           info='Decides the crop ratio!')

    button = gr.Button('CROP!')
    text_box = gr.Textbox(value='0.2', interactive=False)

    button.click(fn=inference, inputs=[image_input, slider], outputs=image_output)
    slider.change(fn=slider_changed, inputs=[slider], outputs=[text_box])

demo.launch()
