import gradio as gr


def inference(x, ratio):
    print(ratio)
    width, height = x.size

    left = int(width * ratio)
    right = int(width * (1 - ratio))
    top = int(height * ratio)
    bot = int(height * (1 - ratio))

    return x.crop((left, top, right, bot))


demo = gr.Interface(fn=inference, inputs=[gr.Image(label='Input', type='pil'),
                                          gr.Slider(minimum=0.01,
                                                    maximum=0.49,
                                                    value=0.2,
                                                    label='Crop ratio',
                                                    info='Decides the crop ratio!')],
                    outputs=gr.Image(label='Output'))

demo.launch()
