\NeedsTeXFormat{LaTeX2e}[95/06/01]
\ProvidesClass{ktherr}
              [2001/05/06 Document Class for KTH Theses, version 1.0a]
\newcommand{\ktherr@papersize}{a4paper}
\newcommand{\ktherr@pointsize}{10pt}
\DeclareOption{a4paper}{\renewcommand{\ktherr@papersize}{a4paper}}
\DeclareOption{a5paper}{\renewcommand{\ktherr@papersize}{a5paper}}
\DeclareOption{b5paper}{\renewcommand{\ktherr@papersize}{b5paper}}
\DeclareOption{letterpaper}{\renewcommand{\ktherr@papersize}{letterpaper}}
\DeclareOption{legalpaper}{\renewcommand{\ktherr@papersize}{legalpaper}}
\DeclareOption{executivepaper}{\renewcommand{\ktherr@papersize}{a4paper}}
\DeclareOption{10pt}{\renewcommand{\ktherr@pointsize}{10pt}}
\DeclareOption{11pt}{\renewcommand{\ktherr@pointsize}{11pt}}
\DeclareOption{12pt}{\renewcommand{\ktherr@pointsize}{12pt}}
\DeclareOption{*}{\PassOptionsToClass{\CurrentOption}{article}}
\ProcessOptions
\LoadClass[\ktherr@papersize,\ktherr@pointsize]{article}
\RequirePackage{geometry}
\geometry{\ktherr@papersize, left=1in, right=1in, top=1in, bottom=1in, nohead}
\def\title#1{\ifx#1[\let\next\@bracket@title\else%
  \gdef\@title{#1}\gdef\@shorttitle{\@title}\let\next\relax\fi\next}
\def\@bracket@title#1]#2{\gdef\@shorttitle{#1}\gdef\@title{#2}}
\def\author#1{\ifx#1[\let\next\@bracket@author\else%
  \gdef\@author{#1}\gdef\@shortauthor{\@author}\let\next\relax\fi\next}
\def\@bracket@author#1]#2{\gdef\@shortauthor{#1}\gdef\@author{#2}}
\def\type#1{\gdef\@type{#1}}
\def\comment#1{\gdef\@comment{#1}}
\def\department#1{\gdef\@department{#1}}
\def\address#1{\gdef\@address{#1}}
\def\imprint#1{\gdef\@imprint{#1}}
\def\publisher#1{\gdef\@publisher{#1}}
\def\trita#1{\gdef\@trita{#1}}
\def\issn#1{\gdef\@issn{#1}}
\def\isrn#1{\gdef\@isrn{#1}}
\def\isbn#1{\@isbntrue \gdef\@isbn{#1}}
\def\dedication#1{\@dedicationtrue \gdef\@dedication{#1}}
\newif\if@isbn \@isbnfalse
\newif\if@dedication \@dedicationfalse
\def\@shortauthor{\@author}
\def\@shorttitle{\@title}
\def\@type{\@latex@warning{No report type given}}
\def\@comment{\relax}
\def\@imprint{\@latex@warning{No imprint given}}
\def\@institute{Royal Institute of Technology}
\def\@department{\@latex@warning{No department given}}
\def\@address{\@latex@warning{No address to the author given}}
\def\@publisher{\@latex@warning{No publisher given}}
\def\@trita{\@latex@warning{No TRITA number given}}
\def\@issn{\@latex@warning{No ISSN given}}
\def\@isrn{\@latex@warning{No ISRN given}}
\let\maketitle\relax
\AtBeginDocument{\@maketitle}
\renewcommand{\@maketitle}{%
  \rightline{\today}\vskip\baselineskip
  \noindent\textbf{Errata for:}  {\let\\=\space\@author, \textit{\@title.}}
  \@type, {\def\\{, }\@department, \@institute.}
  \@date.\par
  \global\let\@maketitle\relax
  \global\let\title\relax
  \global\let\author\relax
  \global\let\date\relax
  \global\let\type\relax
  \global\let\comment\relax
  \global\let\department\relax
  \global\let\address\relax
  \global\let\imprint\relax
  \global\let\publisher\relax
  \global\let\trita\relax
  \global\let\issn\relax
  \global\let\isrn\relax
  \global\let\isbn\relax
  \global\let\dedication\relax
  \global\let\and\relax
}
\newenvironment{errata}{%
  \begin{list}{}{
    \leftmargin=\leftmargini
    \itemindent=-\leftmargini
    \itemsep=0pt
    \raggedright
  }
}
{
  \end{list}
}
\pagestyle{empty}
\endinput
