\NeedsTeXFormat{LaTeX2e}[95/06/01]
\ProvidesClass{kthspik}
              [2000/12/10 Document Class for KTH Theses, version 1.0]
\newcommand\@ptsize{10}
\DeclareOption{g5paper}%
   {\setlength\paperheight {233mm}%
    \setlength\paperwidth  {163mm}%
    \setlength\textheight  {43pc}%
    \setlength\textwidth   {30pc}}
\DeclareOption{s5paper}%
   {\setlength\paperheight {235mm}%
    \setlength\paperwidth  {158mm}%
    \setlength\textheight  {44pc}%
    \setlength\textwidth   {29pc}}
\DeclareOption{a4paper}%
   {\setlength\paperheight {297mm}%
    \setlength\paperwidth  {210mm}%
    \setlength\textheight  {49pc}%
    \setlength\textwidth   {33pc}}
\DeclareOption{9pt}{\renewcommand\@ptsize{9}}
\DeclareOption{10pt}{\renewcommand\@ptsize{10}}
\DeclareOption{11pt}{\renewcommand\@ptsize{11}}
\DeclareOption{12pt}{\renewcommand\@ptsize{12}}
\DeclareOption{draft}{\setlength\overfullrule{5pt}}
\DeclareOption{final}{\setlength\overfullrule{0pt}}
\DeclareOption{fleqn}{\input{fleqn.clo}}
\ExecuteOptions{g5paper,10pt,final}
\ProcessOptions
\RequirePackage{graphics}
\input{kthbk\@ptsize.clo}
\addtolength{\oddsidemargin}{\evensidemargin}
\setlength{\evensidemargin}{.5\oddsidemargin}
\setlength{\oddsidemargin}{\evensidemargin}
\setlength\lineskip{1\p@}
\setlength\normallineskip{1\p@}
\renewcommand\baselinestretch{}
\setlength\parskip{0\p@ \@plus \p@}
\@lowpenalty   51
\@medpenalty  151
\@highpenalty 301
\clubpenalty=9996
\widowpenalty=9999
\brokenpenalty=4991
\predisplaypenalty=10000
\postdisplaypenalty=1549
\displaywidowpenalty=1602
\def\title#1{\ifx#1[\let\next\@bracket@title\else%
  \gdef\@title{#1}\gdef\@shorttitle{\@title}\let\next\relax\fi\next}
\def\@bracket@title#1]#2{\gdef\@shorttitle{#1}\gdef\@title{#2}}
\def\author#1{\ifx#1[\let\next\@bracket@author\else%
  \gdef\@author{#1}\gdef\@shortauthor{\@author}\let\next\relax\fi\next}
\def\@bracket@author#1]#2{\gdef\@shortauthor{#1}\gdef\@author{#2}}
\def\type#1{\gdef\@type{#1}}
\def\comment#1{\gdef\@comment{#1}}
\def\department#1{\gdef\@department{#1}}
\def\address#1{\gdef\@address{#1}}
\def\imprint#1{\gdef\@imprint{#1}}
\def\publisher#1{\gdef\@publisher{#1}}
\def\trita#1{\gdef\@trita{#1}}
\def\issn#1{\gdef\@issn{#1}}
\def\isrn#1{\gdef\@isrn{#1}}
\def\isbn#1{\@isbntrue \gdef\@isbn{#1}}
\def\dedication#1{\@dedicationtrue \gdef\@dedication{#1}}
\newif\if@isbn \@isbnfalse
\newif\if@dedication \@dedicationfalse
\def\@shortauthor{\@author}
\def\@shorttitle{\@title}
\def\@type{\@latex@warning{No report type given}}
\def\@comment{\relax}
\def\@imprint{\@latex@warning{No imprint given}}
\def\@institute{Royal Institute of Technology}
\def\@department{\@latex@warning{No department given}}
\def\@address{\@latex@warning{No address to the author given}}
\def\@publisher{\@latex@warning{No publisher given}}
\def\@trita{\@latex@warning{No TRITA number given}}
\def\@issn{\@latex@warning{No ISSN given}}
\def\@isrn{\@latex@warning{No ISRN given}}
\let\thanks\empty
\newcommand\@make@title@page{%
  \noindent%
  \vbox to 5mm{\vglue-\headheight\vglue-\headsep
      \hbox{\includegraphics{kthsym3s}}\vss}%
  \hfill\par
  \vskip 120\p@
  \begin{center}%
    {\LARGE \@title \par}%
    \vskip 3em%
    {\Large
     \lineskip .75em%
      \begin{tabular}[t]{c}%
        \@author
      \end{tabular}\par}%
    \vfill%
    {\large \@imprint \par}
    \vskip 1em%
    {\large
     \lineskip .75em%
      \begin{tabular}[t]{c}%
        \@type \\ \@institute \\ \@department
      \end{tabular}\par}%
  \end{center}\par
  \vskip 1em%
  {\noindent\@comment\par}%
  \medskip%
  \vbox{\scriptsize\hbox to\textwidth{%
    \hss\if@isbn ISBN~\@isbn\space$\bullet$\space\fi%
    TRITA-\@trita\space$\bullet$\space%
    ISSN~\@issn\space$\bullet$\space%
    ISRN~\@isrn\hss}}\par}
\newcommand\@maketitle{%
  \cleardoublepage
  \@make@title@page
  \newpage
  \global\let\@maketitle\relax
  \global\let\title\relax
  \global\let\author\relax
  \global\let\date\relax
  \global\let\type\relax
  \global\let\comment\relax
  \global\let\department\relax
  \global\let\address\relax
  \global\let\imprint\relax
  \global\let\publisher\relax
  \global\let\trita\relax
  \global\let\issn\relax
  \global\let\isrn\relax
  \global\let\isbn\relax
  \global\let\dedication\relax
  \global\let\and\relax
}
\AtBeginDocument{\@maketitle}
\newenvironment{abstract}{%
  \clearpage%
  {\large\bfseries\hbox to\textwidth{\hss\abstractname\hss}}%
  \par\vskip2.3ex\noindent\ignorespaces%
}{%
  \par\medskip\vbox{\scriptsize\hbox to\textwidth{%
    \hss\if@isbn ISBN~\@isbn\space$\bullet$\space\fi%
    TRITA-\@trita\space$\bullet$\space%
    ISSN~\@issn\space$\bullet$\space%
    ISRN~\@isrn\hss}}\par}
\newcommand*\chaptermark[1]{}
\setcounter{secnumdepth}{2}
\newcounter {part}
\newcounter {chapter}
\newcounter {section}[chapter]
\newcounter {subsection}[section]
\newcounter {subsubsection}[subsection]
\newcounter {paragraph}[subsubsection]
\newcounter {subparagraph}[paragraph]
\renewcommand \thepart {\@Roman\c@part}
\renewcommand \thechapter {\@arabic\c@chapter}
\renewcommand \thesection {\thechapter.\@arabic\c@section}
\renewcommand\thesubsection   {\thesection.\@arabic\c@subsection}
\renewcommand\thesubsubsection{\thesubsection .\@arabic\c@subsubsection}
\renewcommand\theparagraph    {\thesubsubsection.\@arabic\c@paragraph}
\renewcommand\thesubparagraph {\theparagraph.\@arabic\c@subparagraph}
\newcommand\@chapapp{\chaptername}
\setlength\leftmargini  {2.5em}
\leftmargin  \leftmargini
\setlength\leftmarginii  {2.2em}
\setlength\leftmarginiii {1.87em}
\setlength\leftmarginiv  {1.7em}
\setlength\leftmarginv  {1em}
\setlength\leftmarginvi {1em}
\setlength  \labelsep  {.5em}
\setlength  \labelwidth{\leftmargini}
\addtolength\labelwidth{-\labelsep}
\@beginparpenalty -\@lowpenalty
\@endparpenalty   -\@lowpenalty
\@itempenalty     -\@lowpenalty
\renewcommand\theenumi{\@arabic\c@enumi}
\renewcommand\theenumii{\@alph\c@enumii}
\renewcommand\theenumiii{\@roman\c@enumiii}
\renewcommand\theenumiv{\@Alph\c@enumiv}
\newcommand\labelenumi{\theenumi.}
\newcommand\labelenumii{(\theenumii)}
\newcommand\labelenumiii{\theenumiii.}
\newcommand\labelenumiv{\theenumiv.}
\renewcommand\p@enumii{\theenumi}
\renewcommand\p@enumiii{\theenumi(\theenumii)}
\renewcommand\p@enumiv{\p@enumiii\theenumiii}
\newcommand\labelitemi{\textbullet}
\newcommand\labelitemii{\normalfont\bfseries \textendash}
\newcommand\labelitemiii{\textasteriskcentered}
\newcommand\labelitemiv{\textperiodcentered}
\newenvironment{description}
               {\list{}{\labelwidth\z@ \itemindent-\leftmargin
                        \let\makelabel\descriptionlabel}}
               {\endlist}
\newcommand*\descriptionlabel[1]{\hspace\labelsep
                                \normalfont\bfseries #1}
\newenvironment{verse}
               {\let\\\@centercr
                \list{}{\itemsep      \z@
                        \itemindent   -1.5em%
                        \listparindent\itemindent
                        \rightmargin  \leftmargin
                        \advance\leftmargin 1.5em}%
                \item\relax}
               {\endlist}
\newenvironment{quotation}
               {\list{}{\listparindent 1.5em%
                        \itemindent    \listparindent
                        \rightmargin   \leftmargin
                        \parsep        \z@ \@plus\p@}%
                \item\relax}
               {\endlist}
\newenvironment{quote}
               {\list{}{\rightmargin\leftmargin}%
                \item\relax}
               {\endlist}
\newcommand{\abstractname}{Abstract}
\newcommand{\contentsname}{Contents}
\newcommand{\listfigurename}{List of Figures}
\newcommand{\listtablename}{List of Tables}
\newcommand{\bibname}{Bibliography}
\newcommand{\indexname}{Index}
\newcommand{\figurename}{Figure}
\newcommand{\tablename}{Table}
\newcommand{\prefacename}{Preface}
\newcommand{\partname}{Part}
\newcommand{\chaptername}{Chapter}
\newcommand{\appendixname}{Appendix}
\newcommand{\today}{}
\edef\today{\ifcase\month\or
  January\or February\or March\or April\or May\or June\or
  July\or August\or September\or October\or November\or December\fi
  \space\number\day, \number\year}
\pagenumbering{roman}
\pagestyle{empty}
\endinput
