%% hh_thesis.cls
%% This is a LaTeX2e document class fullfilling the layout requirements set by the IDE
%% department of Halmstad University. It is designed to be used when writing the
%% Masters Thesis in Mechatronic Engineering, but but might be usefull for other types
%% of theses as well.
%%
%% This class file is based heavily on the caltech thesis class by Ling Li, with some major
%% changes to the \maketitle command. Some variables are also changed or added to match
%% their new use.
%%

%% CIT_THESIS.CLS
%% Primary LaTeX2e Document Class for Caltech Ph.D. Thesis
%% Ling Li <ling@caltech.edu>
%%
%% This class is an extension of the {report} document class, v1.4b, that
%% formats the title page and chapters according to Caltech's thesis
%% regulations. It additionally adds the ability to use the Lucida Bright
%% font set and have the table of contents render properly, and
%% automatically includes the correct version of the graphicx graphics
%% package when used with LaTeX or pdfLaTeX. This class requires the
%% "setspace" and "graphicx" packages.
%%
%% The files "cit_logo.eps" and "cit_logo.pdf" are the Caltech logos for the
%% title page, and should be distributed with this class.
%%
%% This class supports all options of the {report} document class, plus the
%% following additional options:
%%
%% defended - causes the cover page to list a "Defended" date instead of a
%% "Submitted" date (the date itself is still set the same way it would
%% be in a standard report class document). The option "\ifthesisdefended"
%% allows the author to write conditional code based on whether or not
%% this option is specified.
%%
%% techreport - causes a local publication number (see "\pubnum", below) to
%% be printed on the cover page instead of the copyright year and defense
%% or submission date. (Note: a copyright page is required by Caltech for
%% Ph.D. theses. This page will not be included in a technical report.)
%%
%% doublespace - causes the thesis to be rendered double-spaced, for ease in
%% writing comments
%%
%% draftfoot - adds a draft footer to each page, as well as changing the
%% "Submitted" (or "Defended") line on the cover to indicate that the thesis
%% is a draft copy. The macro "\ifthesisdraft" allows the author to write
%% conditional code based on whether or not this option is specified.
%%
%% lucida - causes the document to be typeset with the Lucida Bright font
%% set, and modifies spacing in the table of contents appropriately. The
%% macro "\iflucidafont" allows the author to write conditional code based
%% on whether or not this option is specified. In order to use lists of
%% theorems with the ntheorem package and Lucida Bright fonts, the author
%% should use the "ntheorem-thesis" style included with this document class;
%% it will format the list of theorems similarly to the list of figures
%% format defined herein.
%%
%% preprint - causes a local publication number (see "\pubnum", below) to be
%% added to the upper right corner of the title page. The macro
%% "\ifthesispreprint" allows the author to write conditional code based on
%% whether or not this option is specified.
%%
%% In addition to these options, the following macros are available:
%%
%% \ifpdf - allows the author to write conditional code based on whether or
%% not pdftex is being used to typeset the thesis. This is potentially
%% important when importing graphics files, and can also be used to
%% determine whether or not to set PDF document attributes.
%%
%% \iftwoside - allows the author to detect whether two-sided layout was
%% selected (for the purpose of including extra blank pages and the like).
%%
%% The following macros are available with this class, in addition to the
%% standard LaTeX macros for the report class (the macro arguments indicate
%% the default values as specified in this class):
%%
%% \degreeaward{Doctor of Philosophy}                 Degree to be awarded
%% \university{California Institute of Technology}    Institution name
%% \department{Pasadena, California}                     Institution department
%% \unilogo{cit_logo}                                 Institution logo
%% \copyyear{\the\year}                               Year on diploma
%% \pubnum{}                                          Publication number
%%
%%
%% The command "\maketitle" will generate a title page and, if applicable, a
%% copyright page conforming to Caltech requirements, and including all the
%% above information. Note that the logo specified in "\unilogo" should be
%% provided as both an .eps and a .pdf file, for use with both regular LaTeX
%% and pdfLaTeX, and the file extension should not be specified.
%%
%% The environment "dedication" will generate a page with the dedication
%% text.
%%
%% The command "\extrachapter" will generate an unnumbered chapter heading,
%% and will produce a corresponding entry in the Table of Contents. This
%% command is used for the {abstract} and {acknowledgements} environments,
%% defined below, and can also be used for extra front matter content such
%% as lists of figures or theorems.
%%
%% The initial portion of the document, which usually includes the abstract,
%% acknowledgements, table of contents, and any lists of figures or other
%% items that may be necessary, is numberred in roman numerals, while the
%% body of the thesis is numbered in arabic numerals. The \maketitle command
%% automatically starts the copyright page and the roman numbering. The
%% author should place the command \mainmatter between the inital portion and
%% the main body of the thesis. Below is the recommended order for components
%% of the front matter:
%%
%%   \maketitle                  % title page and (if not a technical report)
%%                               % copyright page, required by Caltech
%%   \begin{dedication}          % optional dedication
%%     (body of dedication)
%%   \end{dedication}
%%   \begin{acknowledgements}    % optional acknowledgements
%%     (body of acknowledgements)
%%   \end{acknowledgements}
%%   \begin{abstract}
%%     (body of abstract)        % abstract, required by Caltech
%%   \end{abstract}
%%   (tables of contents, figures, other front matter)
%%   \mainmatter
%%
%% The {abstract} and {acknowledgements} environments generate unnumbered
%% chapters that are listed in the table of contents.
%%
%% This class is adapted from Daniel M. Zimmerman's new_cit_thesis.cls,
%% ver 1.2, which was adapted from Michael H. Kelsey's cit_thesis.cls,
%% from February 1995. This class does not work with LaTeX 2.09.
%%

\NeedsTeXFormat{LaTeX2e}[1995/12/01]
\ProvidesClass{hh_thesis}
              [2002/12/08 v1.3.2
 Halmstad University thesis class]

% Define our new \if's
\newif\ifdoublespace
\newif\ifthesisdefended
\newif\iftechreport
\newif\ifthesisdraft
\newif\ifthesispreprint
\newif\iflucidafont
\newif\ifpdf

% Set up \ifpdf
\pdffalse       % no pdfLaTeX
\ifx\pdfoutput\undefined
\else
  \ifx\pdfoutput\relax
  \else
    \pdftrue    % pdfLaTeX
  \fi
\fi

% We require some other packages...
\RequirePackage{setspace}
\RequirePackage{fancyhdr}


% pdflatex dependent packages
\ifpdf
  \RequirePackage[pdftex]{graphicx}
  \pdfcompresslevel=9
  \RequirePackage[usenames,dvipsnames]{color}
\else
  \RequirePackage[dvips,usenames]{color}
  \RequirePackage{graphicx}
\fi

% Our own options
\DeclareOption{defended}{\thesisdefendedtrue}
\DeclareOption{techreport}{\techreporttrue}
\DeclareOption{draftfoot}{\thesisdrafttrue}
\DeclareOption{preprint}{\thesispreprinttrue}
\DeclareOption{lucida}{\lucidafonttrue}
\DeclareOption{doublespace}{\doublespacetrue}

% Load report.cls
\DeclareOption*{\PassOptionsToClass{\CurrentOption}{report}}
\ProcessOptions\relax
\LoadClass{report}[2000/05/19]

\let\iftwoside\if@twoside

% Construct timestamp information for draft-mode footer
\newcount\timehh\newcount\timemm
\newcommand{\thesistime}{%
  \timehh=\time\divide\timehh by 60%
  \timemm=\timehh\multiply\timemm by -60%
  \advance\timemm by \time%
  \ifnum\timehh<10 0\fi\number\timehh\,:\,%
  \ifnum\timemm<10 0\fi\number\timemm%
  \ \ \today}

%defines new margins
\voffset -0.5 in
\hoffset 0 in
\setlength{\oddsidemargin}{0cm}    %% Left margin = 1-1/2 inches
\setlength{\evensidemargin}{0cm}    %% Right margin = 1 1/2 on even pgs
\setlength{\textwidth}{16cm}         %% Makes right margin = 1 inch
\setlength{\topmargin}{0mm}       %% Top margin = 3/4'' inch (incl pg#)
\setlength{\headsep}{.15in}         %% Space between page # and text
\setlength{\textheight}{9.5in}     %% Makes bottom margin = 1 inch
\setlength{\footskip}{.4in}         %% Space from bottom of text to foot

%
% We modify the header and footers to the IDE requirements...
%

\newcommand{\@draftfoot}{DRAFT---NOT FOR DISTRIBUTION\ \hfil\thesistime}
\let\oldTitle\title
\renewcommand{\title}[1]{\newcommand{\myTitle}{#1}\oldTitle{#1}}

\fancyhf{}
\fancyhead[LE]{\hrule height 0.4pt \vskip 1pt\slshape \MakeUppercase \myTitle}
\fancyhead[RO]{\hrule height 0.4pt \vskip 1pt\slshape \leftmark}
\renewcommand{\headrulewidth}{0.4pt}
     \ifthesisdraft
        \fancyfoot[RO]{\@draftfoot\hfill\thepage}
	\fancyfoot[LE]{\thepage\hfill\@draftfoot}
     \else
        \fancyfoot[RO,LE]{\thepage}
     \fi
\renewcommand{\footrulewidth}{0.4pt}

\fancypagestyle{plain}{%
\fancyhf{}
\fancyhead[LE]{\hrule height 0.4pt \vskip 1pt\slshape \MakeUppercase \myTitle}
\fancyhead[RO]{\hrule height 0.4pt \vskip 1pt\slshape \leftmark}
\ifthesisdraft
     \fancyfoot[RO]{\@draftfoot\hfill\thepage}
        \fancyfoot[LE]{\thepage\hfill\@draftfoot}
     \else
        \fancyfoot[RO,LE]{\thepage}
     \fi}

\pagestyle{fancy}

\setcounter{secnumdepth}{3}

%
% Caption title in small italics
%
\long\def\@makecaption#1#2{%
  %\vskip\abovecaptionskip
  \sbox\@tempboxa{\footnotesize\itshape#1\upshape: #2}%
  \ifdim \wd\@tempboxa >\hsize
    \footnotesize\itshape#1\upshape: #2\par
  \else
    \global \@minipagefalse
    \hb@xt@\hsize{\hfil\box\@tempboxa\hfil}%
  \fi
  \vskip\belowcaptionskip}

%
% Chapter headings at top of page, single line format
%
\def\@makechapterhead#1{\vspace*{20pt}
  {\parindent 0pt \raggedright \setstretch{1} \Large\bf%
   \ifnum \c@secnumdepth>\m@ne%
     \thechapter
     \hskip 20pt
   \fi
   \Large \bf
   #1\par \nobreak \vskip 14pt  \setstretch{1.5}}
}               %% End of \@makechapterhead

% Chapter headings at top of page, single line format
\def\@makeschapterhead#1{\vspace*{20pt}
  {\parindent 0pt \raggedright \setstretch{1} \Large\bf%
   #1\par \nobreak \vskip 14pt\setstretch{1.5} }
}               %% End of \@makeschapterhead

% Add a command to create an extra chapter with TOC entry.
\newcommand{\extrachapter}[2][\@empty]{%
  \chapter*{#2}%
  \addcontentsline{toc}{chapter}{\ifx#1\@empty{#2}\else{#1}\fi}}

% Change section size to large
\renewcommand\section{\@startsection {section}{1}{\z@}%
                                   {-3.5ex \@plus -1ex \@minus -.2ex}%
                                   {2.3ex \@plus.2ex}%
                                   {\normalfont\large\bfseries}}

% Change subsection header to italic style
\renewcommand\subsection{\@startsection{subsection}{2}{\z@}%
                                     {-3.25ex\@plus -1ex \@minus -.2ex}%
                                     {1.5ex \@plus .2ex}%
                                     {\normalfont\large\slshape}}

% Change subsubsection header to normal style
\renewcommand\subsubsection{\@startsection{subsubsection}{3}{\z@}%
                                     {-3.25ex\@plus -1ex \@minus -.2ex}%
                                     {1.5ex \@plus .2ex}%
                                     {\normalfont\normalsize\bfseries}}


% Table of contents parameters need to be changed, if we're using Lucida
\iflucidafont
  \renewcommand\@pnumwidth{2.00em}
  \renewcommand\@tocrmarg{2.75em}
\fi

% TOC depth is 3
\setcounter{tocdepth}{3}

% Contents lines for figures/tables aren't indented (support long numbers)
\renewcommand*\l@figure{\@dottedtocline{-2}{0em}{3.2em}}
\renewcommand*\l@table{\@dottedtocline{-2}{0em}{3.2em}}

%
% Define spacing for use on titlepage
%
\newcommand{\titleskip}{\vskip 4\bigskipamount}      %% Whitespace after title
\newcommand{\authorskip}{\vskip 2\bigskipamount}     %% Whitespace after author
%
% We want roman page numbers in the frontmatter, and arabic afterward.
% use \mainmatter to separate them.
%
\newcommand{\mainmatter}{\clearpage\pagenumbering{arabic}}

%
% Additional titlepage definitions
%
\newcommand{\thesistype}{\gdef\@thesistype}
\thesistype{Master of Science}                  % Default is Master of Science.

\newcommand{\university}{\gdef\@university}
\university{Halmstad University}     % Default is Caltech

\newcommand{\unilogo}{\gdef\@unilogo}
\unilogo{hhlogga}                                  % The Halmstad University logo

\newcommand{\coverimg}{\gdef\@coverimg}
\coverimg{coverimg}                             % This is the cover image

\newcommand{\department}{\gdef\@department}
\department{School of Information Science, Computer and Electrical Engineering} % Default is Caltech

\newcommand{\address}{\gdef\@address}
\address{Box 823, S-301 18 Halmstad, Sweden}

\newcommand{\copyyear}{\gdef\@copyyear}
\copyyear{\the\year}                                % Default is today

\newcommand{\pubnum}{\gdef\@pubnum}
\pubnum{}                                           % No publication number

\newcommand{\covercapt}{\gdef\@covercapt}
\covercapt{hej}                                           % The caption for the cover image

%
% The copyright page is new, must conform to CIT requirements
%
\newcommand{\makecopyright}{%
 {\parindent=0pt
 \null              % Forces rest to bottom of page
 \pagestyle{empty}
 \cleardoublepage	    % Puts the copyright page on the odd page
 \begin{center}
 \thispagestyle{empty}
 \bf\Large \@title\\
 \vfill
 \rmfamily\@thesistype\ in Mechatronical Engineering
 \vfill
 \normalsize \@department\\
 \@university\\
 \@address\\
 \vfill
 June\ \@copyyear\\
 \vfill
 \tiny \copyright\quad \@copyyear\\
   \@author\\
   All Rights Reserved
 \end{center}}
 \newpage
 \null 
 \vfill
 \bfseries Cover page picture: \normalfont \@covercapt
}               %% End of \makecopyright
%
% The titlepage must conform to CIT requirements
%
\renewcommand{\maketitle}{%
 {\parindent=0pt
 \pagenumbering{roman}

 \begin{titlepage}
   \let\footnotesize\small \let\footnoterule\relax \setcounter{page}{0}
   \setstretch{1.5}
   %\vskip-\headsep
   %\ifthesispreprint\ifx\empty\@pubnum\else
   %   {\singlespace\hfill\hbox{\begin{tabular}{l}\@pubnum\end{tabular}}}
   %   \titleskip
   %\fi\fi
   {\color{Gray}\hrule height 6.0 pt} %line -----------------------
   \begin{center}
     \iftechreport
%        {\Large \sffamily Technical Report, IDE04\@pubnum, June \@copyyear \par}
	{\Large \sffamily June \@copyyear \par}
     \ifthesisdraft
           {\normalsize (\@draftfoot)\par}
        \else
           \ifthesisdefended
              {\normalsize (Defended \@date)\par}
           %\else
            %  {\normalsize (Submitted \@date)\par}
           \fi
        \fi

     \titleskip
     {\setstretch{1.0}\huge\slshape \MakeUppercase {\@title}\par}
     \titleskip
     \sffamily\Large \@thesistype\ in Mechatronical Engineering\\
     {\@author\par}
     %\authorskip
     \sffamily\Large Supervisor:  Wolfgang Svensson\\
     \vfill
     \includegraphics[height=8cm]{\@coverimg} \\
     \vskip 5mm
     \vfill
     {\color{Gray}\hrule height 6.0 pt} %line -----------------------
     \vskip 4mm
     \begin{picture}(0.8,0.8)(0,41){\includegraphics[width=23mm]{\@unilogo}}		%%hhlogga
     \end{picture}
     \hfill
     \sffamily\normalsize
     \@department\\
     \hfill
     \@university\par
     \vskip 7mm
     {\color{Gray}\hrule height 6.0 pt} %line -----------------------
     %\@copyyear\par

   \end{center}
   %\vspace*{.5in}

 \end{titlepage}
 \setcounter{page}{0}
 \makecopyright
 \fi}
}               %% End of \maketitle

% The dedication page is not part of the Caltech thesis guidelines, but
% is an optional addition to the thesis. It is typically placed before
% the acknowledgements.
\newenvironment{dedication}
  {\parindent=0pt
   \vspace*{.1\textheight}
   \begin{center}}
  {\end{center}\newpage}

% The abstract and acknowledgements are treated as unnumbered chapters
% with Table of Contents entries.
\renewenvironment{abstract}
  {\extrachapter{Abstract}}
  {\clearpage}
\newenvironment{preface}
  {\extrachapter{Preface}}
  {\par\medskip \@author \\
  \@university,\ \@date}
  {\clearpage}
% The {thebibliography} environment should put an entry into the Table
% of Contents, just as the {abstract} and {acknowledgements} environments
% do.

\renewcommand\bibname{References}

\let\thesis@thebibliography\thebibliography

%\def\thebibliography#1{\thesis@thebibliography{#1}%
%  \addcontentsline{toc}{chapter}{References}}
                                                                                                                                                 
\def\thebibliography#1{\thesis@thebibliography{#1}%
  \addcontentsline{toc}{chapter}{Bibliography}}

% If we're using the lucida fonts, let's load them
\iflucidafont
  \RequirePackage{lucidbry}
\fi

\endinput
