function y = playSheetOfMusic1(bPlay,BaseTone,BaseBeat,Sheet)
if nargin < 1,  bPlay = true;    end
if nargin < 2,  BaseTone = 6000; end
if nargin < 3,  BaseBeat = 1;    end
if nargin < 4,  
  Sheet = [1    1.115 0.899  0.45 0.675; ...   
           0.4  0.45  0.55   0.4  1  ];       
end
Fs = 40000;
Sheet(1,:) = Sheet(1,:)*BaseTone;                %scale the frequencies with base tone
Sheet(2,:) = Sheet(2,:)/BaseBeat;                %scale the durations with base beat
nofTones   = size(Sheet,2);                      %nofTones = nofColumns in sheet 

   %BEGIN AUDIO GENERATION
y = [];                           %y starts as the empty vector
for k = 1:nofTones
  aNote = Sheet(:,k);
  yNew = prettyNote4(aNote);
  y = [y yNew];                   %concatenate new audio at end of previous audio
end
   %END AUDIO GENERATION
if bPlay
   sound(y,Fs);                      %play the full song
   totDuration = sum(Sheet(2,:));
   pause(totDuration);
end