function y = prettyNote1(TheNote,bPlay,bDisplay)
if nargin <2,    bPlay = false;     end     %default values of inputs
if nargin <3,    bDisplay = false;  end
Fs = 40000;                                  %sampling frequency
P = TheNote(1);                             %the frequency of the note
L = TheNote(2);                             %the duration of the note
t  = linspace(0,L,Fs*L);                    %time interval

   %BEGIN COMPUTATION
y  = sin(t*P);                              %pure tone
   %END COMPUTATION

if bPlay
  sound(y,Fs); 
  pause(L);
end
if bDisplay
  figure;
  plot(t,y); 
  xlim([0   ,0.01]);   %x axis limit to 0.01 seconds
  ylim([-1.5,1.5]);    
end 
