function y = prettyNote2(TheNote,bPlay,bDisplay)
if nargin <2,    bPlay = false;     end     %default values of inputs
if nargin <3,    bDisplay = false;  end
Fs = 40000;                                 %sampling frequency
P = TheNote(1);                             %the frequency of the note
L = TheNote(2);                             %the duration of the note
t    = linspace(0,L,Fs*L);                  %time interval

   %BEGIN COMPUTATION
tone = sin(t*P);                  %pure tone
lin  = linspace(1,0,Fs*L);        %linear decrease(attenuation)
y    = tone.*lin;                 %generate the audio
   %END COMPUTATION

if bPlay
   sound(y,Fs); 
   pause(L)
end
if bDisplay
    figure;                        %new figure
    subplot(2,1,1);                %make space for two plots in the figure
    plot(t,tone);                  
    title('pure tone')

    subplot(2,1,2);                %second plot in same figure
    plot(t,lin);
    title('linear decrease')
        
    figure;                        %new figure
    plot(t,y)                      %plot resulting audio
    title('synthesized audio')
end 
 
