function y = prettyNote3(TheNote,bPlay,bDisplay)
if nargin <2,    bPlay = false;     end     %default values of inputs
if nargin <3,    bDisplay = false;  end
Fs = 40000;                                  %sampling frequency
P = TheNote(1);                             %the frequency of the note
L = TheNote(2);                             %the duration of the note
t    = linspace(0,L,Fs*L);                  %time interval

   %BEGIN COMPUTATION
lin  = linspace(1,0,length(t));       %linear decrease(attenuation)
y  =  0.7*sin(t*P  ).*lin + ...       %tone with linear attenuation
      0.3*sin(t*P*2).*lin.^2;         %1st overtone with attenuation 
%END COMPUTATION

if bPlay,  
    sound(y,Fs); 
    pause(L)
end

if bDisplay
    figure;                        %new figure
    subplot(2,1,1);                %make space for two plots in the figure
    plot(t,sin(t*P  ).*lin);                  
    title('the tone, with linear attenuation')

    subplot(2,1,2);                %second plot in same figure
    plot(t,sin(t*P*2).*lin.^2);
    title('The overtone, with lin^2 attenuation')
end 

 