/* myGetPr.

just outputs the address of the numerical input variable.

Autor Stefan Karlsson 2012,

for the course Efficient Matlab, Halmstad University
 */
#include "mex.h"

void mexFunction(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[]) {
	
  // Check inputs
  if (nrhs != 1) {//if the user has given anything but one arg, then error
    mexErrMsgIdAndTxt("Numerical:myGetPr:nrhs", "Require one arg");
  }
  if (!mxIsNumeric(prhs[0])) {//if input is not numeric (for example a string), then errror
    mexErrMsgIdAndTxt("Numerical:myGetPr:isnumeric", "Require one arg that is numeric");
  }

  // Check output
  if (nlhs == 0){ // if no outputs, lets echo to the prompt instead
	  mexPrintf("Adress is %X \n", (int)mxGetPr(prhs[0]));}
  else if (nlhs == 1){ //if 1 output, then lets put the address in that one




	  int dims[] = {1,1};  //dimensions of output

	  //create an array of 1 by 1 (i.e. a scalar). It should be of class int32(thus mxINT32_CLASS), and
	  //be strictly real valued(thus mxREAL instead of complex)
	  plhs[0] = mxCreateNumericArray(1,dims, mxINT32_CLASS, mxREAL); 

	  //Finally, we put the address there. mxGetData gets a pointer to our newly made array memory.
	  *((int*) mxGetData(plhs[0])) = (int)mxGetPr(prhs[0]);

  }
  else{ //if we had any number of outputs different from 0 or 1, error:
	  mexErrMsgIdAndTxt("Output:myGetPr:nlhs", "Wrong number of outputs. Use this function with 1 or 0 outputs only");}

return;
}
