%Author: Stefan Karlsson, 2014
function [binIm, Ae, At] = DrawDisk2(r, p, res, bDraw)
if nargin < 2, p = [0, 0];   end
if nargin < 3, res = 40;     end
if nargin < 4, bDraw = true; end

t     = linspace(-1,1,res);
[y,x] = ndgrid(t);

binIm = r -sqrt((x-p(1)).^2 + (y-p(2)).^2)  >= 0;    %make the image


 %estimate area if number of output arguments call for it:
if nargout >1
    %For the true area (of the analytic shape), we have:
   At = pi*r^2;
    %For the Area of estimation, in 3 steps:
    %step 1: how many elements belong to shape:
  NofElements = sum(binIm(:));
    %step 2, how much area does each element have(total width of matrix is 2):
  AreaPerElement =(2/res)^2;
    %step 3,finally:
  Ae = NofElements*AreaPerElement;
end

if bDraw
    imagesc2(t,t,binIm);
    %draw the shape using plot, finely sampled:
    hold on;
    s = linspace(0,2*pi,1000);
    plot(r*cos(s)+p(1),r*sin(s)+p(2), 'r');
    hold off;
end
