%Author: Stefan Karlsson, 2014
function binIm = DrawRectangle1(w, h, p, res,bDraw)
if nargin < 3, p = [0, 0];   end
if nargin < 4, res = 40;     end
if nargin < 4, bDraw = true; end

t     = linspace(-1,1,res);
[y,x] = ndgrid(t);

L = p(1) - w/2;                       %left   limit
R = p(1) + w/2;                       %right  limit
U = p(2) - h/2;                       %upper  limit
B = p(2) + h/2;                       %bottom limit

binIm = (L<=x)&(x<R)&(U<=y)&(y<B);    %make the image
if bDraw
    imagesc2(t,t,binIm);
end