%Author: Stefan Karlsson, 2014
function [binIm, Ae, At] = DrawRectangle2(w, h, p, res,bDraw)
% function DrawRectangle2 draws a rectangle of specified width(w), height(h)
% and position(p), over a res x res image. It returns the Area of the drawn
% rectangle(Ae) and the area of the analytic shape(At). 

if nargin < 3, p = [0, 0];   end
if nargin < 4, res = 40;     end
if nargin < 5, bDraw = true; end

t     = linspace(-1,1,res);
[y,x] = ndgrid(t);

L = p(1) - w/2;                       %left   limit
R = p(1) + w/2;                       %right  limit
U = p(2) - h/2;                       %upper  limit
B = p(2) + h/2;                       %bottom limit

binIm = (L<=x)&(x<=R)&(U<=y)&(y<=B);    %make the image

  %For the true area (of the analytic shape), we have:
At = h*w;

  %For the Area of estimation, in 3 steps:
  %step 1: how many elements belong to shape:
NofElements = sum(binIm(:));
  %step 2, how much area does each element have(total width of matrix is 2):
AreaPerElement =(2/res)^2;
  %step 3,finally:
Ae = NofElements*AreaPerElement;

if bDraw
    imagesc2(t,t,binIm);
    %draw the shape using plot:
    hold on;
    plot([L L R R L],...
         [B U U B B], 'r');
    hold off;
end
