%Author: Stefan Karlsson, 2014
function testSynthesis()

figure;
res = 5:1:100;

for n = 1:length(res),
  subplot(2,1,1);
  
  %get the area of the true shape and the estimated one:
  [~,Ae(n), At(n)] = DrawDisk2(0.8,[0,0],res(n));
% [~,Ae(n), At(n)] = DrawDisk3(0.8,[0,0],res(n),1);


  %on a second axes, we plot the curves of the true area and the
  %estimation:
  subplot(2,1,2);
  plot(res(1:n), At,...    %true area
       res(1:n), Ae);      %estimated area
  xlim([0 1.5*max(res)]);
  legend('Ground truth','Estimation')
  pause(2/n);
end

