function y = prettyNote4(TheNote,bPlay,bDisplay)
if nargin <2,    bPlay = false;     end     %default values of inputs
if nargin <3,    bDisplay = false;  end
Fs = 40000;                                  %sampling frequency
P = TheNote(1);                             %the frequency of the note
L = TheNote(2);                             %the duration of the note
t    = linspace(0,L,Fs*L);                  %time interval

%BEGIN COMPUTATION
c = [ 0.6    0.1    0.3];
lin  = linspace(1,0,length(t));             %linear decrease(attenuation)
y = c(1)*sin(t*P).*lin;                     %the main tone
for k = 2:length(c)
  y = y + c(k)*sin(t*P*k).*lin.^k;          %summation of overtones
end    
%END COMPUTATION

if bPlay,  
  sound(y,Fs); 
  pause(L)
end

if bDisplay
    %plot the resulting audio
    figure;
    plot(t,y)
end 
 
 
