

%Iris Segmentation Groundtruth (IRISSEG-CC Dataset)
%http://islab.hh.se/mediawiki/Iris_Segmentation_Groundtruth

%Copyright 2014: Fernando Alonso-Fernandez, Josef Bigun
%Halmstad University, Sweden
%Contact: Fernando Alonso-Fernandez (feralo@hh.se)

%Please check the link above for instructions on how to reference this
%segmentation dataset on any work made public based directly or indirectly
%on it

%Run this file to obtain the segmentation masks
%Filenames follow the same convention than the original database

%Iris circles
path_segmentation='.\CASIA-IrisV3-Interval_manual_segmentation\';

%Eyelids circles
path_eyelids='.\CASIA-IrisV3-Interval_manual_occlusion_eyelids\'

%Output folder to store the masks
path_out='.\output\';

%Flag to plot eyelids mask (=1)
%Set to zero if only want to plot the iris mask
eyelids_flag=1;

%Size of CASIA IrisV3 Interval images
I=280;
J=320;

[X,Y] = meshgrid(1:J,1:I);

images=dir([path_segmentation '*.mat']);

for im=1:length(images)
    
    im
    
    image=images(im).name;
    
    %Read iris circles and plot
    load([path_segmentation image])
    
    iris_inner=((X-CC_PUPIL(2)).^2+(Y-CC_PUPIL(1)).^2)>=(RADIO_PUPIL*RADIO_PUPIL);
    iris_outer=((X-CC_SCLERA(2)).^2+(Y-CC_SCLERA(1)).^2)<=(RADIO_SCLERA*RADIO_SCLERA);
    
    %Read eyelids circles and plot
    if eyelids_flag==1
        
        load([path_eyelids image(1:end-4) '_eyelids_circles.mat']);
        
        xup=upper_eyelid(1);
        yup=upper_eyelid(2);
        rup=upper_eyelid(3);
        
        xdown=lower_eyelid(1);
        ydown=lower_eyelid(2);
        rdown=lower_eyelid(3);
        
        eyelids_upper=((X-xup).^2+(Y-yup).^2)<(rup*rup);
        eyelids_lower=((X-xdown).^2+(Y-ydown).^2)<(rdown*rdown);
        
        segmentation_mask=iris_inner.*iris_outer.*eyelids_upper.*eyelids_lower;
        
    else
        
        segmentation_mask=iris_inner.*iris_outer;
        
    end
    
    %Save result
    
    %As .mat
    save([path_out image(1:end-4) '.mat'],'segmentation_mask');
    
    %As image
    imwrite(segmentation_mask,[path_out image(1:end-4) '.png']);
    
end

close all



