import numpy as np
from scipy.optimize import minimize

#M-x delete-selection-mode

def rosen(x):
    """The Rosenbrock function"""
    return sum(100.0*(x[1:]-x[:-1]**2.0)**2.0 + (1-x[:-1])**2.0)

def jb(x):
    if x[0] == 7:
        return 0
    return 100

def qf(x):
    a,b,c = 1,1,1
    return ( a*(x[0]**2) + b*x[0] + c )

x0 = np.array([1.3, 0.7, 0.8, 1.9, 1.2, 1.8])
res =minimize(rosen, x0, method='nelder-mead',options={'xtol': 1e-8, 'disp': True})
print res.x


