import numpy, pylab, matplotlib, PIL, colorsys
from matplotlib import pyplot as plt
from pylab import *
from mpl_toolkits.mplot3d import Axes3D

#im = PIL.Image.open('0000009161-2013-04-03 13.30.12.jpg')
im = PIL.Image.open('test.jpg')
#print im.size

R,G,B = [numpy.array(xx.getdata())/255.0 for xx in im.split()]
HSV = numpy.array([colorsys.rgb_to_hsv(r,g,b) for r,g,b in zip(R,G,B)])

fig = plt.figure()
ax = fig.add_subplot(111, projection='3d')

# H,S,V : theta,rho,z

N = 100
H, S, V = [ HSV[:,i] for i in [0,1,2]]

xs = S*numpy.cos(H*2*pi)
ys = S*numpy.sin(H*2*pi)
zs = V

colors = H*2*pi
ax.scatter(xs, ys, zs, c=colors, cmap=cm.hsv)

# lines
xl = arange(0,2)*0
yl = arange(0,2)*0
zl = arange(0,2)
ax.plot(xl, yl, zl, 'r-')

xl = arange(0,2)
yl = arange(0,2)*0
zl = arange(0,2)*0
ax.plot(xl, yl, zl, 'r-')

# circles
thetac = arange(0,2*pi,.01)
xc = numpy.cos(thetac)
yc = numpy.sin(thetac)
zc1 = zeros(thetac.shape)
zc2 = ones(thetac.shape)
ax.plot(xc, yc, zc1, 'r-')
ax.plot(xc, yc, zc2, 'r-')

plt.show()

#matplotlib.colors.rgb_to_hsv(numpy_arr)
